/*------------------------------------------------------------------------------*
 * File Name: Tools.h															*
 * Creation: YuI 07/16/2004													    *
 * Purpose: Origin C header	for ToolBase and derived classes					*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef _TOOLS_H
#define _TOOLS_H
typedef	enum tagORIGINTOOLTYPE
{
	OTT_SELECTOR 		= 0,
	OTT_DATA_READER		= 3,
	OTT_DATA_SELECTOR	= 4,
}	ORIGINTOOLTYPE;
class	ToolBase
{
public:	
	ToolBase();
	~ToolBase();
	
public:
	virtual void	Activate();
	int				GetMode();
};

class	DataSelectorTool	:	public	ToolBase
{
public:	
	DataSelectorTool();
	~DataSelectorTool();
	
public:
	BOOL			SetDataRange(DataRange& dr, int nSubRange);
	BOOL			GetDataRange(DataRange& dr);
	DataSelector	GetDataSelector();
	void			FinishSelection(BOOL bOk);
	void			SetInteractive(BOOL bOn = TRUE);
};

class	DataScreenReaderTool	:	public	ToolBase
{
public:	
	DataScreenReaderTool();
	~DataScreenReaderTool();
};

class	DataReaderTool	:	public	DataScreenReaderTool
{
public:	
	DataReaderTool();
	~DataReaderTool();

public:
	BOOL	GetDataPoint(DataPlot& dp, int& nIndex);
};
#endif //_TOOLS_H
